
function compare(p,q,op)

% function compare(p,q,op)
%
% Compare two sampled signals under operation "op"
%
% op is "none" by default
%
% creates a figure with a 2x2 grid of plots:
%
%   ____________________
%  |                    |
%  |   p       p.orig   |
%  |                    |
%  |   q        p-q     |
%   ____________________
%

% arg process

  if nargin<3, op='none'; end
  

  if strcmp(op,'fft')
    p=fft(p);
    p.orig=fft(p.orig);
    q=fft(q);
  end

  clf
  setplot set

  setplot([2 2 1 1])
    plot(p)
    scale_axis(10,'y')
    ylim = get(gca,'ylim');
    large_ylabel('OBSERVATION')
	
  setplot down
    plot(q)
    set(gca,'ylim',ylim)
    large_ylabel('RECONSTRUCTION')
    
  setplot([2 2 1 2])
    plot(original(p))
    set(gca,'ylim',ylim)
    large_ylabel('ORIGINAL')
    
  setplot down
    plot(original(p)-q)
    set(gca,'ylim',ylim)
    err=100*norm(original(p)-q)/norm(original(p));
    title(sprintf('RELATIVE ERROR = %4.2f%%',err))
    large_ylabel('ERROR')
    
  setplot end

  SetUserData('p',p)
  SetUserData('q',q)

  
function large_ylabel(str)

  ylabel(str)
  
  h=get(gca,'ylabel');
  set(h,'color','y','fontsize',12)