
function r=conv(p,q)

% function r=conv(p,q)
%
% Convolution (performed in Fourier domain)
%
% conv(<sampled_signal>,<sampled_signal>)      
% conv(<sampled_signal>,<scalar>)  % convolve p with itself q times
 

% matrix case

   np=length(p(:));
   nq=length(q(:));
   
   if any(size(p)~=size(q))
     error('Invalid array sizes')
   end
   
   for ii=1:max(np,nq)
     r(ii) = scalar(p(min(ii,np)),q(min(ii,nq)));
   end
   r = reshape(r,max([size(p); size(q)]));
   
   
% scalar case

function r=scalar(p,q)

% do it

   if isscalar(q)
     p = zeropad(p,round(log2(q)));
     r = ifft(fft(p).^q);
   else
     p = zeropad(p,1);
     q = zeropad(q,1);
     r = ifft(fft(p).*fft(q));
   end  
   
% name 

   if strcmp(p.nametrack,'on')
     if isscalar(q)
       r.name = sprintf('%s**_{%d}%s',para(p.name),q-1,para(p.name));
     else
       r.name = sprintf('%s**%s',para(p.name),para(q.name));
     end  
   end
   
