
function W = cwt(p,FB)

% function W = cwt(p,FB)
%
% "Continuous" or Overcomplete Wavelet Transform 
%
% <wavelet> = icwt(<sampled_signal>,[<struct filter_bank>])
%
% INPUT:
%	p  = inverse cwt of W <sampled_signal>
%       FB = filter bank structure with fields
%
%          ghatbank  = wavelet filter bank <sampled_signal>
%          scales    = associated scale (dilation) values <double>
%          name      = name of wavelet family
%
% OUTPUT:
%	W  = wavelet object
%
% See Also:
%   icwt, uibank, GetFB, plot

% time sample structure of filter bank

   gd = 1./(2*FB.ghatbank.d([2 1]));
   
% Force f to match sample structure of filter bank

   p = p(:);
   p = join(resample(p,gd)); % make one sampled signal
   
% Perform CWT in freq domain

   [nsamps,nsigs]    = size(p.sig);
   [nsamps,nfilters] = size(FB.ghatbank.sig);
   
   Wp = sampled_signal(zeros(nsamps,nfilters,nsigs),gd);
    
   disp(sprintf('Computing cwt...'))
   
   sighat = fft(p.sig);
   
   bankhat = sfftshift(FB.ghatbank.sig);
   for ii=1:nsigs
     disp(sprintf('...signal %d of %d',ii,nsigs))
      
     Wp.sig(:,:,ii) = ...
	 ifft(sighat(:,repmat(ii,1,nfilters)).*bankhat);
   end
   disp(sprintf('...done computing cwt.'))
   
   Wp.d0   = p.d0;
   
   W = wavelet(FB,Wp,p);


