
function p=delta_dist(p,ndeltas)

   if nargin<2, ndeltas=10; end   

% matrix case

   for ii=1:length(p)
     p(ii)=scalar(p(ii),ndeltas);
   end

    
%  scalar case

function q=scalar(p,ndeltas)

   q=abs(p);
   
   nn=size(q.sig);
   colsig=reshape(q.sig,prod(nn(1:end-1)),nn(end));
   colsig2=colsig.^2;
   
   for ii=1:size(colsig,2)
     colsig(:,ii) = colsig(:,ii)/max(colsig(:,ii));
   end
   
   q.sig = zeros(ndeltas,size(colsig,2));
   q.d   = [1/ndeltas (1+1/ndeltas)/2];
   q.d0  = 1;
   
   delta = lattice(q);
   norm2 = sum(colsig2);
   for ii=2:length(delta)
%     q.sig(ii,:) = sum((colsig>delta(ii)).* colsig2)./norm2;
      q.sig(ii,:) = sum(colsig<delta(ii))./size(colsig,1)./delta(ii);
   end
   
   q.name = sprintf('CR_{\\delta}(%s)',p.name);
   q.xlabel = '\delta';
   q.ylabel = '';

