
function p = dilate(p,scale,n)

% function p = dilate(p,scale,n)
%
% L^n dilation of p.sig by the value scale

% arg process

   if nargin<3, n=2; end

   if scale==1, return, end   % need to do anything?
   
% matrix case

   for ii=1:length(p(:))
     p(ii)=scalar(p(ii),scale,n);
   end
   

% scalar case

function p=scalar(p,scale,n)

   p.d = p.d/scale;
      
   if n~=1
     p.sig  = scale^(1/n)*p.sig;
   end
   
   if strcmp(p.nametrack,'on')
     if n==2
       p.name = sprintf('D_{%s}%s',num2str(scale),p.name);
     else
       p.name = ...
	   sprintf('D^{%s}_{%s}%s',num2str(n),num2str(scale),p.name);
     end
   end
 