
function p=dist(p,nbins)

% function prob=dist(p,nbins)
% 
% Computes the probabilitiy distribution of range 
% values in the sampled signal p
%
% Uses an L1 normalized hist so that norm(prob,1)=1
%
% See Also hist.m

% arg process

   if nargin<2, nbins=10; end   

% matrix case

   for ii=1:length(p)
     p(ii)=scalar(p(ii),nbins);
   end

    
%  scalar case

function p=scalar(p,nbins)

   if ~isreal(p)
     disp('Warning (dist.m): data not real (using real part)')
     p=real(p);
   end
   
   nn=size(p.sig);
   colsig=reshape(p.sig,prod(nn(1:end-1)),nn(end));
   
   [ncount,xx] = hist(colsig,nbins);
   
   ss = sum(ncount,2)*(xx(2)-xx(1));
   
   p.sig = (ncount./repmat(ss,size(ncount,1),1)).';
   p.d   = xx.';
   
   p.name = sprintf('Dist(%s)',p.name);
   p.xlabel = 'Value';
   p.ylabel = 'Probability';

