

function p = downsample(p,dfactor)

% function p = downsample(p,dfactor)
%
% INPUT:
%	p	sampled signal matrix 
%       dfactor integer factor by which to down sample [ 2 ]
%
% OUTPUT:
%	subsampled by factor of dfactor signal matrix pair


% arg process

  if nargin<2, dfactor=2; end

% do it

  for ii=1:length(p)
    p(ii) = scalar(p(ii),dfactor);
  end
  
%
%
%

function p=scalar(p,dfactor)

% init

  [rows,cols] = size(p.sig);

% subsample

  p.sig  = p.sig(1:dfactor:rows,:);
  p.d    = [dfactor 1].*p.d;

  
  p.name = sprintf('S^{-}_%s %s',num2str(dfactor),p.name);
