
function p=dtrndp(p)

% matrix case

    for ii=1:length(p)
      p(ii)=scalar(p(ii));
    end

    
%  scalar case

function phase=scalar(p)

   % compute the frequency

   phase = unwrap(angle(p));	
   
   % detrend whole signal but only along the 3dB pts
   
   MM = [lattice(p) ones(size(p.sig,1),1)];
   
   p3dB = normalize(abs(p),inf)>0.5;
   for ii=1:size(phase.sig,2)
     ind = find(p3dB.sig(:,ii));
     
     mb = MM(ind,:)\phase.sig(ind,ii);  % compute slope and intercept of
                                        % best line fit along 3dB support
     
     phase.sig(:,ii) = phase.sig(:,ii) - MM*mb; % remove the line along
                                                % the entire support
   end
   
   phase.name   = sprintf('DTRNDP(%s)',p.name);
   phase.ylabel = 'Phase (rads)';

   % window
   
   
   win12dB = name(normalize(abs(p),inf)>0.125,'win12dB');
   phase   = phase.*win12dB;
