

function val = entropy(p)

% function Hp = entropy(p)
%
% computes entropy, Hp, of p(x) as sum(p(x).*log2(x))
%
% If p is a valid probability distribution, i.e.,
% sum(p,1)=1 then Hxx is the entropy in the 
% probabilistic sense.
%
% Else p is made into a distribution by an affine
% transformation


% matrix case

   for ii=1:length(p(:))
     val{ii}=scalar(p(ii));
   end
   val = reshape(val,size(p));
   if length(val)==1, val=val{1}; end

   
% scalar case

function val=scalar(p)

   val = zeros(size(p.sig,2),1);
   
   if length(p.d)==2
     delta=p.d(1);
   else
     delta=p.d(2)-p.d(1); % assumes uniform sampling!
   end
   
   
   nn=size(p.sig);
   xx=reshape(p.sig,prod(nn(1:end-1)),nn(end));
   
   for ii=1:nn(end);
     val(ii) = delta*raw_entropy(xx(:,ii));
   end
   

% supporting functions

function Hxx = raw_entropy(xx)

% is it a valid distribution?

  if abs(sum(xx)-1) > 100*eps
    mm=min(xx)-eps;
    MM=max(xx);

    xx = (xx-mm)./(MM-mm);
    xx = xx./sum(xx);
  end
  
% replace 0's with 1's to avoid NaN's
% this is OK since lim_{x->0} xlog(x) = 0 
% and xlog(x)|_{x=1} = 0.

  ii=find(xx==0);
  xx(ii)= ones(size(xx(ii)));
  
% compute the result
  
  Hxx = -sum(xx .* log2(xx));



