
function r=eq(p,q)

% matrix case

   np=length(p(:));
   nq=length(q(:));
   
   if np>1 & nq>1 & any(size(p)~=size(q))
     error('Invalid array sizes')
   end
   
   for ii=1:max(np,nq)
     r(ii) = scalar(p(min(ii,np)),q(min(ii,nq)));
   end
   r = reshape(r,max([size(p); size(q)]));

   
% scalar case

function b = scalar(p,q)

     if isscalar(p), b=q; else b=p; end
     
     if isscalar(p)
       b.sig = p==q.sig;
     elseif isscalar(q)
       b.sig = p.sig==q;
     elseif all(p.d==q.d)
       b.sig = p.sig==q.sig;
     else
       b  = abs(p-q)<eps; % does nec. resampling
     end

     
     if strcmp(b.nametrack,'on')
       b.name = sprintf('%s==%s',name(p),name(q));
     end
     
