
function val = eval2(p,x,y)

% evaluate 2D sampled signal (image) p at arbitrary (x,y) location
%
% note that x and y must be of the same dimension

% approximate indices by nearest neighbors

  xind = fix(x/p.d(1)) + n0(p);
  
  if isempty(p.dy)
    yind = fix(y) + n0(p,'y');
  else
    yind = fix(y/p.dy(1)) + n0(p,'y');
  end

% initialize new values to zero

  val = zeros(size(x));

% fill in only the valid range (x,y) points with data
  
  valid_ind = find( (xind>0 & xind<=size(p.sig,1)) & ...
      (yind>0 & yind<=size(p.sig,2)) );
  
  xind = xind(valid_ind);
  yind = yind(valid_ind);
  
  val(valid_ind) = p.sig(xind+size(p.sig,1)*(yind-1));