
function p=fft(p)

% function p=fft(p)
%
% fast Fourier transform for sampled signal


% matrix case

   for ii=1:length(p(:))
     p(ii)=scalar(p(ii));
   end
   

% scalar case

function p=scalar(p)

   p.sig = sfftshift( fft(sfftshift(p.sig)) ) * p.d(1);
   p.d   = 1./(2*p.d([2 1]));
   p.d0  = 0;

   if strcmp(p.nametrack,'on')
     p.name   = sprintf('%s\\^',para(p.name));
     p.xlabel = GetGlobal('FreqLabel','default','Freq (MHz)');
   end
   
  
  
  