
function p=freq(p)

% matrix case

    for ii=1:length(p(:))
      p(ii)=scalar(p(ii));
    end

    
%  scalar case

function freq=scalar(p)

   % compute the frequency

   phase = unwrap(angle(p));	
   freq  = der(phase)./(2*pi);
   
					      
   freq.name   = sprintf('FREQ(%s)',p.name);
   freq.ylabel = GetGlobal('FreqLabel','default','Freq (MHz)');

   win12dB = name(normalize(abs(p),inf)>0.125,'win12dB');
   freq    = freq.*win12dB;
