
function W = fwt(f, h,g, nscales)

% function W = fwt(f, h,g, nscales)
%
%    <sampled_signal> = fwt(<sampled_signal>, <double>,[<double>, <int>])
%
% INPUTS:
% 	f	sampled_signal object
% 	h 	low  pass filter
% 	g	high pass filter [qmf(h)]
% 	nscales # of scales to compute [ all ]
%
% OUTPUTS:
%	W 	sampled_signal object
%
% EXAMPLES:
%	fwt(f, h), fwt(f, h,g)


% arg process

   if nargin<3, g=qmf(h); end
   if nargin<4, nscales=[]; end % 2^coarse_scale samples

% init

   [rows,cols] = size(f.sig);
   fine_scale  = log2(rows);

   if fine_scale ~= round(fine_scale)
     error('function must have a power of 2 samples')
   end
   
   if isempty(nscales), nscales=fine_scale-1; end
   
   coarse_scale = max(fine_scale-nscales+1,floor(log2(length(h))));

% descend wavelet tree

   Lf = f;
   W  = sampled_signal(zeros(rows,cols),f.d);

   for ii=fine_scale:-1:coarse_scale+1
     [Hf, Lf] = downcell(Lf, h,g);	
     W.sig( (2^(ii-1)+1):2^ii,:) = Hf.sig;
   end
   W.sig(1:2^coarse_scale,:)  = Lf.sig;
   W.d 			      = Hf.d;

% output

   module_output('fwt',coarse_scale,fine_scale)

