
function Wim = fwt2(im, nlevels,h,g)

% function Wim = fwt2(im, nlevels,h,g)
%
% 2D fast wavelet transform

% arg process

   if nargin<4, g=qmf(h); end
   
% init

   im.sig = zeropad(im.sig);
   im.sig = zeropad(im.sig.').';
   
   [rows,cols] = size(im.sig);
   
   nlog2  = min(log2(rows),log2(cols))-1;

% descend wavelet tree

  
   Wim=setfield(im,'sig',zeros(rows,cols));
   LL    = im.sig.';

   for ii=1:min(nlevels,nlog2);
     
     n1 = size(LL,1);
     n2 = size(LL,2);
     
     LLd = default_structure(LL);
     [Hr,Hrd, Lr,Lrd] = downcell(LL,LLd, h,g);
     
     LrHr  = [Lr; Hr].';
     LrHrd = default_structure(LrHr);
     
     [Hc,Hcd, Lc,Lcd] = downcell(LrHr,LrHrd, h,g);
     
     Wim.sig(1:n2,1:n1) = [Lc; Hc];
     
     LL = Wim.sig(1:n2/2,1:n1/2).';
   end

