
function fwtdisp(W, f, mode, scale)

% function fwtdisp(W, f, mode, scale)
%
% Display DWT in various formats as indicated by mode
%
% INPUT:
%	W	FWT of f (sampled signal object)
%	f	sampled signal object
% 	mode 	one of 'abs', 'real','imag', 'angle', or 'complex'
% 	scale	multiplicative factor applied to f and W
%
% OUTPUT:
%	Graphical Display

% arg processing

	if nargin<3, mode = 'abs'; 	end
	if nargin<4, scale= 1; 	end
	
        name= GetUserData('name');
	
	delete(findobj(gcf,'type','axes'))
	[coarse_scale, fine_scale] = module_input('fwt');

	do_points=1;
        if nargin<2
	  
	  f      = GetUserData('f');
	  W      = GetUserData('W');	  
	  scales = GetUserData('scales');
	  
	  coarse_scale = scales(1);
	  fine_scale   = scales(2);
	  
	end
	
	mode = ui_get_string('mode');
	[scale,do_points,do_TS]= ui_get_numerical('X Fac|points|T/S');
	mode_is_complex = strcmp(lower(mode),'complex');
	

% init

	corder=get(gca,'colororder');
	ncolors = length(corder(:,1));

	[rows,cols] = size(W);
	nlog2	    = log2(rows);

	Wscale = 0.5*scale/max(abs(W(:)));
	W = Wscale*W;
	
	the_title=sprintf('%s DWT',upper(mode));
	if scale>1
	  the_title=sprintf('%s  (%dX)',the_title,scale);
	end

% plot 'em

	if mode_is_complex
	  plot(f.sig+(nlog2+1)*ones(size(f.sig)))
	  axis('equal')
	  setplot([1 1 1])
	elseif do_TS
	  setplot([6 1 1.2 1])
	    tt = lattice(f);
	    h=plot(tt, 4*real(f.sig)+1+(nlog2+1)*ones(size(f.sig)));
	    set(h,'color',0.5*[1 1 1])
	    set(gca,'visible','off')
	    
	    title(sprintf('Real(%s)',f.name));
	    h=get(gca,'title');
	    set(h,'Visible','on')
	    set(h,'HorizontalAlignment','center','VerticalAlignment','middle')
	    setplot([1.075 1 1.075 1])
	else
	  setplot([1 1 1])
	end
	      
	hold on
	   for ii=coarse_scale:fine_scale
	     
	     Wsd = [ 2^(coarse_scale-ii+1)*W.d(1) W.d(2) ];
	     Ws  = sampled_signal(W.sig((2^(ii-1)+1):2^ii,:),Wsd);
	     
	     if mode_is_complex
	       
	       plot(Ws.sig+j*ii)
	       hold on
	       
	       plot(0,ii,'cx')
	       circle(max(abs(Ws.sig(:))),j*ii)
	       
	       ylabel('Scale')
	       
	     else
	       if strcmp(mode,'angabs')
		 Ws = der(unwrap(angle(Ws)))/(2*pi)/10 ...
		        .* (abs(Ws)>0.2*max(abs(Ws.sig(:))));
	       else
		 eval(sprintf('Ws = %s(Ws);',mode));
	       end
	       
	       if strcmp(mode,'angle')
		 Ws = Ws./(2*pi); % normalize
	       end
	       
	       index = mod(ii-1,ncolors)+1;
	       
	       if do_TS
		 tt = lattice(Ws);
		 hh=plot(tt,Ws.sig+ii);
		 set(hh,'color',corder(index,:))
	 
		 if do_points
		   set(hh,'color',0.3*[1 1 1])
		   hh=plot(tt,Ws.sig+ii);
		   set(hh,'Marker','o','color',...
		       corder(index,:),'MarkerSize',3)
		 end
		 hold on
	 		 
		 xlabel('Time')
		 ylabel(sprintf('Scale  (%s)',the_title))
	       else
		   hh=plot(2^(ii-1)+(1:length(Ws.sig(:,1))),Ws.sig);
		   set(hh,'color',corder(index,:))
		   hold on
		 if do_points
		   set(hh,'color',0.3*[1 1 1])		   
		   hh=plot(2^(ii-1)+(1:length(Ws.sig(:,1))),Ws.sig);
		   set(hh,'LineStyle','o','color',...
		       corder(index,:),'MarkerSize',4)
		 end
		 xlabel('Index')
		 ylabel(sprintf('Amplitude  (%s)',the_title))
	       end
	       
	     end
	   end

        if ~isempty(name), label_plot(['Wavelet: ' name]), end

	hold off
	
	close_button
