

function p=hilbert(p)

% function p=hilbert(p)
%
% Hilbert transform for sampled signal


% matrix case

   for ii=1:length(p(:))
     p(ii)=scalar(p(ii));
   end
   

%   
% scalar case
%

function p=scalar(p)

   p.sig = local_hilbert(p.sig);

   if strcmp(p.nametrack,'on')
     p.name   = sprintf('Hilbert(%s)',p.name);
   end

   
%
%
%
  
   
function y=local_hilbert(x)
  
   [r,c] = size(x);
   if r == 1
     x = x.';   % make it a column
   end;
   [n,cc] = size(x);
   m = 2^nextpow2(n);
   y = fft(real(x),m);
   if m ~= 1
     h = [1; 2*ones(fix((m-1)/2),1); ones(1-rem(m,2),1); zeros(fix((m-1)/2),1)];
     y(:) = y.*h(:, ones(1,cc) );
   end
   y = ifft(y,m);
   y = y(1:n,:);
   if r == 1
     y = y.';
   end
