
function p=hist(p,nbins)

% function p=hist(p,nbins)
%
% Computes histogram of range values in
% sampled signal

% arg process

   if nargin<2, nbins=10; end   

% matrix case

   for ii=1:length(p)
     p(ii)=scalar(p(ii),nbins);
   end

    
%  scalar case

function p=scalar(p,nbins)


   if isreal(p)
     [nn,xx] = hist(p.sig,nbins);
   else
     [nnr,xx] = hist(real(p.sig),nbins);
     nni = hist(imag(p.sig),nbins);
     nn  = nnr + j*nni;
   end
   
   p.sig = nn;
   p.d   = xx;
   
   p.name = sprintf('Hist(%s)',p.name);
   p.xlabel = 'Value';
   p.ylabel = '# occurances';

