
function p=ifft(p)

% function p=ifft(p)
%
% ifft of sampled signals

% matrix case

   for ii=1:length(p(:))
     p(ii)=scalar(p(ii));
   end
   

% scalar case

function p=scalar(p)

   p.sig = sfftshift( ifft(sfftshift(p.sig)) ) * 2*p.d(2);
   p.d   = 1./(2*p.d([2 1]));
   
   if strcmp(p.nametrack,'on')
     p.xlabel = GetGlobal('TimeLabel','default','Time (\mus)');
     p.name = sprintf('%s\\vee',para(p.name));
   end

  
   
