
function f=ifwt(W, h, Lf0) 

% function f=ifwt(W, h, Lf0) 
%
% INPUTS:
%       W     sampled signal in which each column
%             is the 1d fwt of the corresponding signal in f
%
%       h     low (+high) pass FIR filter(s)
%
% OUTPUTS:
%       f,fd  reconstructed sampled signal matrix of size(Wf)
%
% EXAMPLES:
%
%	ifwt(Wf,h)

% arg process

   [rows,cols] = size(h);
   if cols==1
     g=qmf(h);
   else
     g=h(:,2); h=h(:,1);
   end

% init

   [rows,cols] = size(W.sig);
   nlog2 =log2(rows);
   if nlog2~= round(nlog2)
     error('function must have a power of 2 samples')
   end
   
   [coarse_scale,fine_scale] = module_input('fwt');
   
   if nargin>3
     ii=min(find(abs(Lf0.sig(:,1))>0));
     coarse_scale = round(log2(ii))-1;
     fine_scale = nlog2-1;
     Lf = Lf0.sig(2^coarse_scale:2^(coarse_scale+1)-1,:);
   else
     Lf = W.sig(1:2^coarse_scale,:);
   end
   
   Lf = sampled_signal(Lf,W.d);
   
   % reconstruct f from terminal node to root of wavelet tree
   
   for ii=coarse_scale:fine_scale-1
     Hf = sampled_signal(W.sig((2^ii+1):2^(ii+1),:),Lf.d);
     Lf = upcell(Hf, Lf, h,g);
   end

   f=Lf;


