
function himage=imagesc(p,yy)

% function himage=imagesc(p,yy)
%
% Display sig data as (concatenated) image
%
% imagesc(<SS>)
% imagesc(<SS>,<length m double>)
% 
% <SS> must have either 2 or 3 dimensions
%  m   must be equal to size(p.sig,2)
%

% arg process

   if nargin<2, yy=[]; end

   for ii=1:length(p(:))
     if ii~=1, pop inf, end
     him(ii)=scalar(p(ii),yy);
   end
 
   if nargout>0, himage=him; end
   
   
   
function him=scalar(p,yy)

% arg process

   if isempty(yy)
     yy=lattice(p,2);
   end
   
   if length(yy)~=size(p.sig,2)
     warning('y-axis mismatch')
   end
   
   
% show only the abs if complex and warn user

   [n1,n2,n3] = size(p.sig);
   
   if ~isreal(p.sig)
     disp('Warning: image data not real (using abs)')
     p.sig = abs(p.sig);
   end
   
   map = eval(p.colormap);
   colormap(map)
   
% concatenate (wavelet) images along single (time) axis

   p.sig = permute(p.sig,[2 1 3]);
   p.sig = reshape(p.sig, n2,n3*n1);
   
   p.d   = [1 n3].*p.d;
   
% display concatentated image

   him=imagesc(lattice(p),yy,p.sig);

   xlabel(p.xlabel)
   ylabel(p.ylabel)
   
   title(p.name)
   
   set(gca','ydir','normal')


