
% function p = int(p)
%
% provides approximate integration
% using Simpson's method

function p = int(p)

% matrix case

   for ii=1:length(p(:))
     p(ii)=scalar(p(ii));
   end
   

% scalar case

function p=scalar(p)

% Simpson's approximate integral

   p.sig  = cumsum(p.sig)*p.d(1);
   
   if strcmp(p.nametrack,'on')
     p.name = sprintf('\\int%s',para(p.name));
   end
