
function b=isequal(p,q,name)


% function b=isequal(p,q,name)
%
% Tests sampled signals p and q for equality
% in the element given by name, e.g.,
%
%    isequal(p,q,'name')  % tests if p and q have the same name, 
%                         % i.e., p.name==q.name?
%

% arg process

   if nargin<3, name='sig'; end
   
% matrix case

   np=length(p(:));
   nq=length(q(:));
   
   if np>1 & nq>1 & any(size(p)~=size(q))
     error('Invalid array sizes')
   end
   
   for ii=1:max(np,nq)
     b(ii) = scalar(p(min(ii,np)),q(min(ii,nq)),name);
   end
   b = reshape(b,max([size(p); size(q)]));
   
   
% scalar case

function b=scalar(p,q,name)

   eval(sprintf('p = p.%s;',name))   
   eval(sprintf('q = q.%s;',name))
   
   b = isequal(p,q);
   
