
function r=join(p,q)

% function r=join(p,q)
%
% Concatenate matrices of sampled signals to a
% single sampled signal with resampling if necessary
%
% r.sig is a length(p(:))+length(q(:)) signal matrix
%
% See Also split.m

   if nargin==1

     if length(p)==1, r=p; return, end

     r    = p(1);
     lastname = p(end).name;
     
     p=p(:);
     dd = reshape([p.d],2,length(p))';
     newd=sample_structure([min(dd(:,1)) max(dd(:,2))]);
     p=resample(p,newd);
     
     r.sig  = [p.sig];
     r.d    = newd;
%     r.SNR  = [];

     if strcmp(r.nametrack,'on')
       if length(p)==2
	 r.name = sprintf('[%s, %s]',r.name,lastname);
       else
	 r.name = sprintf('[%s...%s]',r.name,lastname);
       end
     end 
 
   else
     r=join([ p(:); q(:) ]);
   end

