

function tt = lattice(p,dim,nwrap)

% function tt = lattice(p,dim,nwrap)
%
% create a sample set (column vector) associated with 
% sample structure p.d = [ Delta T ] where 
%
%   Delta = sample rate
%   T     = half width of the interval
%
%   p.d0 = 0 indicates an interval [-T,T)
%   p.d0 = 1 indicates an interval [0,2T) %]
%
%   nwrap = number of samples to extend lattice on either side
%
% tt is a column vector

% arg process

   if nargin<2, dim=1; end
   if nargin<3, nwrap=0; end
   
% matrix case

   for ii=1:length(p(:))
     tt{ii} = scalar(p(ii),dim,nwrap);
   end
   tt = reshape(tt,size(p));
   
   if length(tt)==1, tt=tt{1}; end
   
   
% scalar case

function tt=scalar(p,dim,nwrap)

 
   if dim=='x', dim=1; end
   if dim=='y', dim=2; end

   if dim==2
     if ~isempty(p.dy0)
       p.d0(2,:) =p.dy0;
     else
       p.d0(2,:) =1;
     end
     if length(p.dy)==2
       p.d(2,:)=p.dy;
     end
   end

   if length(p.d)>2 % x-points
     tt=p.d(dim,:);
     return
   end
     
   if size(p.d,1)<dim
     p.d(dim,:) = [1 size(p.sig,dim)/2];
   end
   if size(p.d0,1)<dim
     p.d0(dim) = 1;
   end
      
   tt = lattice(p.d(dim,:),p.d0(dim),nwrap);
   


