

function [coef,skip,mode]=lmispe(p)

% function coef=lmispe(p)
%
%   Compute the LMISPE coefficients

% matrix case

    for ii=1:length(p(:))
      [coef(ii),skip(ii),mode(ii)]=scalar(p(ii));
    end
    coef=reshape(coef,size(p));
    skip=reshape(skip,size(p));
    mode=reshape(mode,size(p));

    
    
%  scalar case

function [coef,skip,mode]=scalar(p)

  % init

  thresh_mul = .5;
  dig_thresh = max(abs(p.sig))/10;

  % Create a matrix of magnitudes for bound computations

  mag_pulses=abs(p.sig);
  
  % Find index information

  [rough_m,final_m,maxout,maxind ]=LMISPEpw(mag_pulses,dig_thresh,thresh_mul);

  % Compute Pulse Widths

  p_width=final_m(2,:)-final_m(1,:)+1;

  % Compute Mode Info

  [skip,num_pts,mode,skip_mat]=LMISPEmode(p_width);

  % Adjust pointers by skip_start 

  final_m(1,:)=final_m(1,:)+skip_mat(1,:);

  % Find Phases

  phase_mat = doPhases(p.sig,final_m,skip,num_pts);

  % Find Frequencies

  freq_mat = doFreqs(phase_mat,0);


  % Generate Coefficients

  
  lodft_coef     = gen_lodft(freq_mat,mode,num_pts);
  lodft_coef     = split_coef(lodft_coef);
  
  lodft_coef(1,:)=zeros(size(lodft_coef(1,:))); % zero DC
  
  lodft_coef(2:9,:) = lodft_coef(2:9,:) + ...
      j*[lodft_coef(10:16,:); zeros(size(lodft_coef(1,:)))];
  
  lodft_coef(10:end,:)=[];

  % output

  mode = mode(1);
  
  coef = sampled_signal(lodft_coef,1);


  coef.name   = sprintf('LMISPE(%s)',p.name);
  coef.d0     = 1;
  coef.xlabel = 'Index';   
  coef.ylabel = 'Amplitude';   
  


  skip=skip(1);  % assume they are the same???