
function p = mconv(p, h, ctype)

% function ph = mconv(p, h, ctype)
%
% Perform convolution (with periodic extension) of sampled
% signal p with fixed digital filter h
%
% INPUT:
%	p	sampled signal matrix with signal size MxN
%	h	FIR filter (column vector) of length K
%	ctype	boundary handling ('none' | ['wrap'] )
%
% OUTPUT:
%	ph	the convolution p*h = [ A1*h A2*h ... An*h ]
%		with size (M+K)xN


% arg process

   if nargin<3, ctype='wrap'; end

   for ii=1:length(p(:))
     p(ii)=scalar(p(ii),h,ctype);
   end
   


function ph=scalar(p,h,ctype)

% nothing fancy, just a big for loop... is there a better way?

   [rows,cols]   = size(p.sig);
   [rowsh,colsh] = size(h);

   if rowsh>rows
     [p.sig,h] = swap(p.sig,h);
     rows=rowsh; cols=colsh;
   end

   if rem(length(h),2), h = [ 0; h(:) ]; end
   
   nh = length(h);
   nn=1:nh/2;
   
   ph = sampled_signal(zeros(rows,cols),p.d);
   
   if strcmp(ctype,'wrap')
     for ii=1:cols
       cc = conv(h,[p.sig(rows-fliplr(nn)+1,ii); p.sig(:,ii); p.sig(nn,ii)]);
       ph.sig(:,ii) = cc(nh+(1:rows),:);
     end
   else
     for ii=1:cols
       cc = conv(h,p.sig(:,ii));
       ph.sig(:,ii) = cc(nh/2+(1:rows),:);
     end
   end
   
   if strcmp(p.nametrack,'on')
     ph.name = sprintf('%s*%s',para(p.name),name(h));
   end

