
function mm = mean(p,dim)

% function mm = mean(p,dim)
%
%  dim=1:  Compute the mean of each signal in p
%
%  dim=2:  Compute the mean signal
%

   if nargin<2, dim=1; end

% matrix case

   if dim==1

     for ii=1:length(p(:))
       mm{ii} = scalar(p(ii),dim);
     end
   
     mm =reshape(mm,size(p));
   
     if length(p)==1, mm=mm{1}; end
   else
     mm=p;
     for ii=1:length(mm(:))
       mm(ii) = scalar(mm(ii),dim);
     end
   end
   
     
% scalar case

function p=scalar(p,dim)

   p.sig  = mean(p.sig,dim);
   
   if dim==1 % signal means so return as vector
     p = p.sig;
   elseif strcmp(p.nametrack,'on')
     p.name = sprintf('mean(%s)',p.name);
   end
