
function r = minus(p,q)

% function r = minus(p,q)
% 
% minus(<1x1 SS>,<const>)
% minus(<1x1 SS>,<arb. dimension SS>)
%
% minus(<arb. dimension SS>,<same dimension SS>)
%
% where SS = 'sampled signal'
%
% FOR 1x1 SS
%
% <scalar> -    p      % pure scalar subtract
%     p    - <scalar>
%
% <1 x n>  -    p      % each column signal of p is scalar subtracted
%    p     -  <1 x n> 
%
%       p  -  q        % sampled signals are subtracted with 
%                      % resampling if necessary


   r = plus(p,-q);

   for ii=1:length(r)
     r(ii).name = strrep(r(ii).name,'+-','-');
   end
   