
function r=mtimes(p,q)

% function r=mtimes(p,q)
%
% matrix multiply pf sampled signals
%
% mtimes(<m x k  SS>, <k x n  SS>)
%
% mtimes(<m x k dbl>, <k x n  SS>)
% mtimes(<m x k  SS>, <k x n dbl>)
%

   [prows,pcols] = size(p);   
   [qrows,qcols] = size(q);
   
   if pcols~=qrows
     error('Inner matrix dimensions must agree.')
   end
   
   for ii=1:prows
     for jj=1:qcols
       r(ii,jj) = p(ii,1).*q(1,jj);
       for kk=2:pcols
	 r(ii,jj) =  r(ii,jj) + p(ii,kk).*q(kk,jj);
       end
     end
   end
   