
function out = name(p,str)

% function out = name(p,str)
%
%    p      = name(p,<string>)  % sets p's name to string
%    string = name(p);          % gets p's name

% arg process

   if nargin<2, str=[]; end
    
% matrix case

   nstr=size(str,1);
   for ii=1:length(p(:))
     out{ii} = scalar(p(ii),str(rem((1:nstr)+ii-2,nstr)+1,:));
   end
   
   out = reshape(out,size(p));
   
   if length(p)==1, out=out{1}; end


% scalar case

function out=scalar(p,str)

   if ~isempty(str)
     p.name = deblank(str(1,:));
     out    = p;
   else
     out = p.name;
   end
   
   