
function val = norm(p,n)

% function val = norm(p,n)
%
%   Compute the L^n norm of the sampled signal p
%
%   n=inf means max normalization

   if nargin<2, n=2; end
   
% matrix case

   for ii=1:length(p(:))
     val{ii}=scalar(p(ii),n);
   end
   val = reshape(val,size(p));
   if length(val)==1, val=val{1}; end

% scalar case

function val=scalar(p,n)

   if isinf(n)
     val=max(abs(p.sig));
   elseif length(p.d)==2
     sig  = abs(p.sig).^n;
     val = (sum(sig,1) .* p.d(1)).^(1/n);
   else
     sig  = abs(p.sig).^n;

     sig  = (sig(1:(end-1),:) + sig(2:end,:))/2;
     
     size(sig)
     size(diff(p.d))
     
     val = (sum(sig.*diff(p.d),1)).^(1/n);
   end
   
   

