
function p = normalize(p,n)

% function p = normalize(p,n)
%
%   Normalize the sampled signal p using the L^n norm
%
%   n=inf means max normalization

   if nargin<2, n=2; end
   
% matrix case

   for ii=1:length(p(:))
     p(ii)=scalar(p(ii),n);
   end
   

% scalar case

function p=scalar(p,n)

   if ndims(p.sig)>2
     error('sig data must not be more than 2 dimensional')
   end

   val = norm(p,n); % returns cell array but...
		  
   for ii=1:size(p.sig,2)
     p.sig(:,ii) = p.sig(:,ii)/val(ii);
   end
   
   if strcmp(p.nametrack,'on')
     p.name = sprintf('Norm(%s)',p.name);
   end
   

