
function hout=plot(p,varargin)

% function hout=plot(p,varargin)
%
% plot sampled signal matrix
%
% hout = matrix of line handles,                   if p is 1x1 sampled_signal 
% hout = a cell array of line handles of size(p),  ELSE
%
% plot(<sampled_signal>)
% plot(<sampled_signal>,<sampled_signal of same dimension>,...)


%   state=setplot(1);
   
   make_axes = length(p)>1 | isempty(findobj(gcf,'type','axes'));

   [rows,cols] = size(p);
   
     for ii=1:rows
       for jj=1:cols
	 if make_axes, setplot([rows cols ii jj]), end
	   pij=p(ii,jj);
	   
	   hplot{ii,jj,1}=cplot(lattice(pij),pij.sig);

	   name = pij.name;

	   hold on
	   for kk=1:length(varargin)
	     pk = varargin{kk};
	     if all(size(pk)==size(p))
	       pk=pk(ii,jj);
	     else
	       pk=pk(1);
	     end
	     
	     hplot{ii,jj,kk+1}=cplot(lattice(pk),pk.sig);
	     set_line_props(hplot{ii,jj,kk+1},kk);
	     name = sprintf('%s, %s',name,varargin{kk}.name);
	   end
	   hold off
	   
	   if ~isempty(name), title(name), end
	   set_axis_props(pij)
       end
     end
%   setplot(state)
   
   if nargout>0
     hout=hplot;
     if length(hout)==1, hout=hout{1}; end
   end
   
     
%
%
%
     
function set_line_props(h,kk)

   markers = {'o','diamond','v','square','pentagram','x','.'};
   
   marker = markers{mod(kk,length(markers))};
   
   set(h,'Marker',marker,'MarkerSize',4,'MarkerFaceColor','auto')
   
   for ii=1:length(h)
     color=get(h(ii),'Color');
     set(h(ii),'Color',color/log2(1.5+ii))
   end

   

%
%
%

function set_axis_props(p)

   xlabel(p.xlabel)
   ylabel(p.ylabel)
   if strncmp(lower(p.grid),'on',2), grid, end
   set(gca,'box',p.box,'buttondownfcn',p.buttondown)

   % label only integer indices on x-axes?
   
   if strncmp(lower(p.xlabel),'index',5)
     xlim = get(gca,'xlim');
     xtick= get(gca,'xtick');
     
     if ~isint(xtick)
       set(gca,'xtick',xlim(1):ceil((xlim(2)-xlim(1))/length(xtick)):xlim(2));
     end
   end
   
   
   

