
function r = plus(p,q)

% function r = plus(p,q)
% 
% plus(<1x1 SS>,<const>)
% plus(<1x1 SS>,<arb. dimension SS>)
%
% plus(<arb. dimension SS>,<same dimension SS>)
%
% FOR 1x1 SS
%
% <scalar> +    p      % pure scalar add
%     p    + <scalar>
%
% <1 x n>  +    p      % each column signal of p is scalar added
%    p     +  <1 x n> 
%
%       p  +  q        % sampled signals are added with 
%                      % resampling if necessary


% matrix case

   np=length(p(:));
   nq=length(q(:));
   
   if np>1 & nq>1 & any(size(p)~=size(q))
     error('Invalid array sizes')
   end
   
   swapped=0;
   if (np==1 & isa(q,'double')) | (nq==1 & isa(p,'double'))
     if isa(p,'double')
       [p,q] = swap(p,q); 
       swapped=1;
     end
     r = scalar(p,q,swapped);
   else
     for ii=1:max(np,nq)
       r(ii) = scalar(p(min(ii,np)),q(min(ii,nq)),swapped);
     end
     r = reshape(r,max([size(p); size(q)]));
   end
   
   
% scalar case
   
function p=scalar(p,q,swapped)   
   
   if isscalar(p)
     const=p;
     p=q;   
     p.sig = p.sig + const;
     
   elseif isscalar(q)
     
     const=q;
     
     p.sig = p.sig + const;

   elseif isa(q,'double')
     if ~isempty(p.sig)
       if length(q)==size(p.sig,2) 
     
	 q = q(:).'; % make it a row vector
       
	 p.sig  = repmat(q,size(p.sig,1),1) + p.sig;
       end
     end
   else
   
     yd = [ min(p.d(1),q.d(1)), max(p.d(2),q.d(2))];
     yd = sample_structure(yd);
     
     y1 = resample(p, yd);
     y2 = resample(q, yd);
     
     p.sig  = y1.sig+y2.sig;
     p.d    = yd;
   
   end

% name
   
   if strcmp(p.nametrack,'on')
     if swapped
       p.name = sprintf('%s+%s',name(q),name(p));
     else
       p.name = sprintf('%s+%s',name(p),name(q));
     end    
   end
   
   
  
