

function r = powerdB(p)

% function p = powerdB(p)
%
% Computes power in dB of signals in p


% matrix case

   for ii=1:length(p(:))
     r{ii}=scalar(p(ii));
   end
   
   r = reshape(cell2out(r),size(p));
   
   
% scalar case

function p=scalar(p)
   
   p.sig  = sum(real(p.sig).^2 + imag(p.sig).^2,1).*p.d(1);
   p.sig  = 10*log10(p.sig);
   
   if length(p.sig)==1  % a single signal generates one number
     
     p=p.sig; 
     
   else                 % a function of pulse index
     
     p.d      = [1 size(p.sig,2)/2];
     p.d0     = 1;
     p.xlabel = 'Index';
     p.ylabel = 'Power (dB)';
     p.name   = sprintf('POWER(%s)',p.name);
     
   end
   
   
  

   
   

