
function [out,proj] = rotate2(p,theta)

% function out = rotate2(p,theta)
% 
%   Rotate the two dimensional function ``p''
%   by theta degrees
%
%   the rotated function ``out'' will have rectangular
%   dimensions large enough to accomodate the rotated
%   version

% init

   in = p.sig;
   
% theta in degrees (0, 90) and a quadrant

   if theta<0, theta = 360*ceil(abs(theta)/360) + theta; end
   theta = mod(theta,360);

   quad  = ceil(theta/90);
   theta = mod(theta,90);
   
   quad = quad + (theta==0);

   switch quad
     
     case 2
       in = flipud(in.');
       [p.d(1),p.dy(1)] = swap(p.d(1),p.dy(1));
       
     case 3
       in = flipud(fliplr(in));
  
     case 4
       in = flipud(in).';
       [p.d(1),p.dy(1)] = swap(p.d(1),p.dy(1));
   end
   
   quad, theta

   if theta==0
     out=in;
     return
   end
 
% convert to radians

   theta = pi/180 * theta;
   
% compute the positions of the rotated indices

   [rows,cols] = size(in);
   
   ii = (1:cols)*p.dy(1);
   jj = (1:rows)*p.d(1);
   
   indicesy = repmat(ii,rows,1);
   indicesx = repmat(jj',1,cols);
   

   ct=cos(theta);
   st=sin(theta);

   % form the rotation matrix

   RR = [ ct -st; st ct; ];
   
   Rindices = RR * [indicesx(:)'; indicesy(:)'];
   
   if 0
     clf
     plot(indicesx(:,[1 end]),indicesy(:,[1 end]),'co')
   
     hold on
     plot(Rindices(1,1:rows),Rindices(2,1:rows),'yo')
     plot(Rindices(1,(end-rows):end),Rindices(2,(end-rows):end),'yo')
   end
   
   
% compute the dimensions of the rotated output matrix

   wx=max(Rindices(1,:))-min(Rindices(1,:))
   wy=max(Rindices(2,:))-min(Rindices(2,:))
  
   dx = (p.d(1)*ct + p.dy(1)*st)
   dy = (p.d(1)*st + p.dy(1)*ct)
   

   nx = round(wx/dx)+1
   ny = round(wy/dy)+1
  
   mm =  mean(abs(in(:)))
   out = repmat(mm,nx,ny);
   
   % round to closest sample point index
   
   Rindices(1,:) = round((Rindices(1,:)-min(Rindices(1,:)))/dx)+1;
   Rindices(2,:) = round((Rindices(2,:)-min(Rindices(2,:)))/dy)+1;
  
   
% map original sample points to rotated sample points

   xi = Rindices(1,:)+ nx*(Rindices(2,:)-1);
   
   out(xi') = in(:);

   
   
   

   if 1
   
   
   Display([1.35 1 1 1])
   
   colormap(hot)
   out = abs(out);
   
   imagesc((1:nx)*dx,(1:ny)*dy,out.')   
   set(gca','ydir','normal')
   xlim = get(gca,'xlim');
   title([p.name ', theta=' num2str(theta*180/pi)])

   Display([3 1 3 1])
   
   proj = sum(out,2);
   proj = proj - mean(proj);
   plot((1:nx)*dx,proj)
   set(gca,'xlim',xlim)
   
   title(sprintf('slope = %s',num2str(tan(theta))))
   
   Display end
   
 end
 