
function out = rotate2(p,theta)

% function out = rotate2(p,theta)
% 
%   Rotate the two dimensional function ``p''
%   by theta degrees
%
%   the rotated function ``out'' will have rectangular
%   dimensions large enough to accomodate the rotated
%   version

% init

   in = p.sig;
   
% theta in degrees (0, 90) and a quadrant

   if theta<0, theta = 360*ceil(abs(theta)/360) + theta; end
   theta = mod(theta,360);
   
   quad  = ceil(theta/90);
   theta = mod(theta,90);
   
   quad = quad + (theta==0);

   switch quad
     
     case 2
       in = flipud(in.');
       
     case 3
       in = flipud(fliplr(in));
  
     case 4
       in = flipud(in).';
   end

   if theta==0
     out=in;
     return
   end
   
% convert to radians

   theta = pi/180 * theta;
   
% compute the positions of the rotated indices

   [rows,cols] = size(in);
   
   ii = 1:rows;
   jj = 1:cols;
   
   indicesx = repmat(ii',1,cols);
   indicesy = repmat(jj,rows,1);

   % form the rotation matrix

   RR = [ cos(theta) -sin(theta); sin(theta) cos(theta) ];
   
   Rindices = RR * [indicesx(:)'; indicesy(:)'];
   
   % round to closest sample point index
   
   Rindices = round(Rindices);
   
% compute the dimensions of the rotated output matrix

   xd = round([rows cols]*[cos(theta); sin(theta)])
   yd = round([rows cols]*[sin(theta); cos(theta)])
   
   out = zeros(xd,yd);
   
% map original sample points to rotated sample points

   xi = Rindices(1,:)+ xd*(Rindices(2,:)-1);
   
   xi = xi +  xd-max(Rindices(1,:));
  
   out(xi') = in(:);
   
   ct=cos(theta);
   st=sin(theta);
   dx = (p.d(1)*ct + p.dy(1)*st);
   dy = (p.d(1)*st + p.dy(1)*ct);
   

   
   Display([1 1 1])
   plot(indicesx*p.d(1),indicesy*p.dy(1),'co')
   hold on
   plot(Rindices(1,:)*dx,Rindices(2,:)*dy,'yo')
   Display end

   if 0
   
   
   Display([1.35 1 1 1])
   
   colormap(hot)
   
   imagesc(flipud(out.'))   
   xlim = get(gca,'xlim');
   title([p.name ', theta=' num2str(theta*180/pi)])

   Display([3 1 3 1])
   plot(sum(out,2))
   set(gca,'xlim',xlim)
   
 end
 