
function [p,params] = quantize(p,varargin)

% function [p,params] = quantize(p,args)
%
% quantize function values
%
% argument parameters include
%
%    'nbits'
%    'delta'

% arg process

   if nargin<2, varargin=[]; end
   
   params = process(varargin);

   del = params.delta;
   nbits = params.nbits;
   
% matrix case


   switch params.type
     case '+'
       step = (1-del)/(2^(nbits)-1/2);
       levels = del+step:step:1;         
       levels = [ 0 levels ];
       
     otherwise
       step = (1-del)/(2^(nbits-1)-1/2);
       levels = del+step:step:1;         
       levels = [ -fliplr(levels) 0 levels ];
   end
   
   disp(sprintf('Quantizing using %d levels',length(levels)));
   
   for ii=1:length(p(:))
     p(ii)=scalar(p(ii),levels,params);
   end
   
   % scalar case

   function p=scalar(p,levels,params)
   
   levels = levels*max(norm(p,inf));
   
   if isreal(p.sig)
     p.sig = Q(p.sig,levels,params);
   else
     p.sig = Q(real(p.sig),levels,params) + j*Q(imag(p.sig),levels,params);
   end
   
   
   % name
   
   if strcmp(p.nametrack,'on')
     p.name = sprintf('Q^{%s}_{%d}(%s)',...
	 params.type,ceil(log2(length(levels))),p.name);     
   end


   
function sig=Q(sig,levels,params)

   jjplus=find(sig>0);
   jjminus=find(sig<0);

   sig(jjplus) = Qpos(sig(jjplus),levels);
   
   if ~strcmp(params.type,'+')
     sig(jjminus) = -Qpos(-sig(jjminus),levels);
   else
     sig(jjminus) = zeros(size(jjminus));     
   end
   


function sig=Qpos(sig,levels)

   jj = find(sig(:)<levels(1));
   sig(jj) = repmat(levels(1),length(jj),1);
   
   jj = find(sig(:)>=levels(end));
   sig(jj) = repmat(levels(end),length(jj),1);
   
   for ii=1:length(levels)-1
     aa = levels(ii);
     bb = levels(ii+1);
     jj = find(sig(:)>=aa & sig(:)<bb);
     sig(jj) = repmat(levels(ii),length(jj),1);
   end



function params=process(args)

% defaults

   default_args = {...
       'nbits', 4, ...
       'delta', 0, ...
       'type',  '-' ...
       };

% init params to defaults

   for ii=1:2:length(default_args)
     eval( sprintf('params.%s=default_args{ii+1};',default_args{ii}) );
   end
   
% update according to input args

   for ii=1:2:length(args)
     eval( sprintf('params.%s=args{ii+1};',args{ii}) );
   end
   
   

