
function r = rdivide(p,q)

% function r = rdivide(p,q)
% 
% rdivide(<1x1 SS>,<const>)
% rdivide(<1x1 SS>,<arb. dimension SS>)
%
% rdivide(<arb. dimension SS>,<same dimension SS>)
%
% FOR 1x1 SS
%
% <scalar> ./    p      % pure scalar divide
%     p    ./ <scalar>
%
% <1 x n>  ./    p      
%    p     ./  <1 x n> 
%
%       p  ./  q        % sampled signals are divided with 
%                      % resampling if necessary

% matrix case

   np=length(p(:));
   nq=length(q(:));
   
   if np>1 & nq>1 & any(size(p)~=size(q))
     error('Invalid array sizes')
   end
   
   for ii=1:max(np,nq)
     r(ii) = scalar(p(min(ii,np)),q(min(ii,nq)));
   end
   r = reshape(r,max([size(p); size(q)]));

   
% scalar case

function p = scalar(p,q)

   if isscalar(p)
     const=p;
     p=q;
     
     p.sig = p.sig / const;
     p.name = sprintf('%s/%s',num2str(const),para(p.name));
     
   elseif isscalar(q)
     
     const=q;
     
     p.sig = p.sig / const;
     p.name = sprintf('%s/%s',para(p.name),num2str(const));
     
   elseif isa(q,'double')
     if ~isempty(p.sig)
       if length(q)==size(p.sig,2)

	 q = q(:).'; % make it a row vector
       
	 p.sig =  p.sig ./ q(ones(size(p.sig,1),1),:) ;
	 p.name = sprintf('[%s...%s]./%s',...
	     num2str(q(1)),num2str(q(end)),para(p.name));
       else
	 error('Scalar matrix and sampled signal must have same dimensions')
       end
     end
   else

     yd = [ min(p.d(1),q.d(1)), max(p.d(2),q.d(2))];
   
     y1 = resample(p, yd);
     y2 = resample(q, yd);
   
     p.sig = y1.sig ./ y2.sig;
     p.d   = yd;

   % labels and units

     if strcmp(p.nametrack,'on')
       p.name   = sprintf('%s./%s',para(p.name),para(q.name));
       p.xlabel = unit_test(p,q);
     end     
   
   end
   
   

   
