
function p=resample(p,pd_new,t0)

% function p=resample(p,pd_new,t0)
%
% resample the function p with sample structure p.d 
%	with respect to the new sample structure pd_new 
%       and possible offset t0
%
%       method of resampling is controlled by p.interp
%
%       zero values in pd_new are substituted with the
%       corresponding value in p.d


% arg process

   if nargin<3, t0=0; end
   if isa(pd_new,'sampled_signal')
     pd_new=pd_new(1).d;
   else % fill in zero values with p.d data as default
     ii=find(pd_new==0);
     pd_new(ii) = p(1).d(ii);
   end
   
% init

   pd_new = sample_structure(pd_new);
    
% matrix case

   for ii=1:length(p(:))
     p(ii)=scalar(p(ii),pd_new,t0);
   end
   

   
   
% scalar case

function p=scalar(p,pd_new,t0)

% interpolate or shift?


    if p.d(1)~=pd_new(1) | t0~=0
      
      resfac = log2(p.d(1)/pd_new(1));
      
      if abs(resfac)>2
	disp(sprintf(...
	    'Warning: resfac=%s, resampling accuracy may be inadequate',...
	    num2str(resfac)))
      end
      
      presd  = [pd_new(1) min([pd_new(2) p.d(2)])];
      pres   = sampled_signal(presd);
      pres.d0=p.d0;
	
      tt     = lattice(p);      
      tt_res = lattice(pres);
      
      if t0 ~= mod(t0,pres.d(2))
	% disp('Warning: translation wrapping!')
	t0 = mod(t0+(~p.d0)*presd(2),2*pres.d(2))-(~p.d0)*presd(2);
      end
      
      
      % wrap around for interpolation
      
      nwrap = min([ceil(4+abs(t0)/p.d(1)),length(tt),length(tt_res)]);
      
      nn = length(tt);
      iiwrap = [ (nn-nwrap+1):nn 1:nn 1:nwrap];
       
      p.sig = ...
	  interp1(lattice(p,1,nwrap),p.sig(iiwrap,:),tt_res-t0,p.interp);
    end

% zero pad or truncate?
  
    [rows,cols] = size(p.sig);
    p.d = pd_new;
    nn = round(2*p.d(2)/p.d(1));
    nz = (nn-rows)/2;

    if nz>0
      p.sig  = [ zeros(nz,cols); p.sig; zeros(nz,cols) ];
    elseif nz<0
      p.sig([1:-nz (rows+nz+1):rows],:)=[];
    end

