
function [rotp,proj] = rotate2(p,thetadeg)

% function out = rotate2(p,theta)
% 
%   Rotate the two dimensional function ``p''
%   by theta degrees
%
%   the rotated function ``out'' will have rectangular
%   dimensions large enough to accomodate the rotated
%   version

  for ii=1:length(thetadeg)
    disp(sprintf('theta=%s, %d of %d',...
	num2str(thetadeg(ii)),ii,length(thetadeg)))
    
    rotp(ii,1)=scalar_theta(p,thetadeg(ii));
    
    if nargout>1
      proj(ii,1) = compute_proj(rotp(ii));
    end
  end


function rotp=scalar_theta(p,thetadeg)

% init

  p.d0=0;  
  p.dy0=0;
  
% assume theta in degrees (convert to radians)

  theta = thetadeg*pi/180;

% Make rotation (by -theta) matrix

  cc = cos(theta);
  ss = sin(theta);
  
  RR = [cc -ss; ss cc];
  
% sizes depend only on magnitude of cos and sin of theta

  cc = abs(cc);
  ss = abs(ss);

% initialize rotated sampled signal with proper sample structures

  rotp = sampled_signal;
  
  rotp.d(1)  = p.d(1)*cc.^2 + p.dy(1)*ss.^2;
  rotp.d(2)  = p.d(2)*cc    + p.dy(2)*ss;
  
  rotp.dy(1) = p.d(1)*ss.^2 + p.dy(1)*cc.^2;
  rotp.dy(2) = p.d(2)*ss    + p.dy(2)*cc;
  
  rotp.d  = sample_structure(rotp.d);
  rotp.dy = sample_structure(rotp.dy);

  
% compute dimensions of rotated image (M x N)

  M = round(2*rotp.d(2)./rotp.d(1));
  N = round(2*rotp.dy(2)./rotp.dy(1));
  
% make the rotated rectangular lattice
  
  rotp_xy = lattice2(rotp); % (MxN) x 2
    
% rotate the rectangular lattice by angle -theta 

  Rxy = rotp_xy*RR;  % (MxN) by 2
  
% reshape for evaluating image on rotated lattice 

  Rxy = permute(reshape(Rxy,N,M,2),[2 1 3]);
  
% do the evaluation
   
  rotp.sig = eval2(p,Rxy(:,:,1),Rxy(:,:,2));

  rotp.name = sprintf('R_{%s} %s',num2str(thetadeg),p.name);
  
return
  

% diagnostic stuff

  xy  = lattice2(p);
  
  plot(xy(:,1),xy(:,2),'g+')
  hold on
  plot(rotxy(:,1),rotxy(:,2),'co')
  plot(Rxy(:,:,1),Rxy(:,:,2),'rx')
  hold off
  setplot end
  axis('equal')
  
  
function xy=lattice2(p)

% make the a list of points (npoints x 2) on the 
% rectangular lattice associated with p

  xx=lattice(p,'x');
  yy=lattice(p,'y');
  
  XX = repmat(xx.',length(yy),1            );
  YY = repmat(yy,  1,            length(xx));
  
  xy = [ XX(:) YY(:) ];


      
function proj=compute_proj(im)


  % im = abs(im);
   
% compute projection

  % proj = sampled_signal(sum(im.sig,2)./max(50,sum(im.sig>0,2)),im.d);
  % proj.d0=im.d0;
   
  proj = (sum(im.^2,2)./size(im.sig,2)).^.5;
   

 % proj = abs(der(proj));  % remove edge bias

  proj = name(proj,sprintf('Proj %s',name(proj)));


