%
%  sets p.d to admissible sampling structure 
%  based on p.sig and sample_period

function p = sample_structure(p,sample_period)

% arg process

   if nargin==1
     p = p.d;
   else
     
     n1 = size(p.sig,1);
   
     if mod(n1,2)~=0
       disp('Warning: sample structure left padded to multiple of 2')
       disp('         origin may be inaccurate')
     
       n1=n1+1;
     
       p.sig = [repmat(0,1,size(p.sig,2)); p.sig];
     end
   
     p.d = sample_period*[1 n1/2];
   end
   
