
function [p,mb] = sdetrend(p,a,b)

% function p  = sdetrend(p,a,b)
%
% Detrend a sampled function matrix over an
% interval. Fits a straight line to the function
% over the interval and removes it from the entire function.
%
% a,b are optional arguments indicating the interval of
%	of detrending (they are times not indices)


% argument processing

	if nargin<2, error('3 arguments required'); end

	for ii=1:length(p(:))
	  [p(ii),mb{ii}] = scalar(p(ii),a,b);
	end
	

function [p,mb]=scalar(p,a,b)

% make x-lattice and confine signal and lattices to pertinent intervals

	tt = lattice(p);
	
	[dd,n0] = min(abs(a-tt));
	[dd,n1] = min(abs(b-tt));

	pp_I = p.sig(n0:n1,:);
	tt_I = tt(n0:n1);

	[rows ,cols ] = size(p.sig);
	[rowsI,colsI] = size(pp_I);

% make the linear fit matrices 

	A   = [tt   ones(rows ,1)];
	A_I = [tt_I ones(rowsI,1)];

% compute the least squares (psuedo inverse) slope and intercept on
%	pertinent interval only

	mb = A_I\pp_I;

% compute the detrended function over the entire function

	p.sig  = p.sig - A*mb;



