
function p=select(p,in2,in3)

% function p=select(p,in2,in3)
%
%   p=select(p,indices)    % sets p to the signals indicated by indices
%                          % i.e., p=p(:,indices)
%
%   p=select(p,q,indices); % sets signals indicated by indices to the
%                            values in q, i.e., "p(:,indices)=q"
%  

   switch class(in2)
     
     case 'double'
   
       ss = size(p.sig);

       p.sig = reshape(p.sig,prod(ss(1:end-1)),ss(end));
       ss(end) = length(in2);
       
       p.sig = p.sig(:,in2);
       
       p.sig = reshape(p.sig,ss);
   
     case 'sampled_signal'
       
       if length(in3)==size(in2.sig,2)
	 p.sig(:,in3) = in2.sig;
       else
	 error('Mismatched sampled signal assignment')
       end
       
   end
   
   