
function p = set_structure(p,sample_period)

%
%  sets p.d to admissible sampling structure 
%  based on p.sig and sample_period

% arg process

   if nargin<2
     if ~isempty(p.d)
       sample_period=p.d(1); 
     else
       sample_period=1;
     end
   end
   

   n1 = size(p.sig,1); % number of samples
   

% if odd number of samples left pad with 1 sample to make even
   
   if mod(n1,2)~=0 
     disp('Warning: sample structure left padded to multiple of 2...')
     disp('         origin may be inaccurate')
     
     n1=n1+1;
     
     p.sig = [repmat(0,1,size(p.sig,2)); p.sig];
   end
   
% the sample structure   
   
   p.d = sample_period*[1 n1/2];

