
% shift.m
%
% shift(f,nn, dim, cyclic)
%
% 	shifts each column of f  n times to the right
%		if nn<0 then shifts left abs(n) times
%		[nn=1 by default]
%
% 	if dim	='r' shifts rows up (n<0) and down (n>0)
% 		[mode ='c' by default]
%
%	cyclic = TRUE for cyclic shifts (default) or 0
%		for zero padding
%
% if nn is a row(col) length vector each col(row) 
% 	is shifted by the corresponding nn

function f = shift(f,nn, dim, cyclic)


  switch nargin
    
    case 2
      f.sig = shift(f.sig,nn)
      
    case 3
      f.sig = shift(f.sig,nn,dim);

    case 4
      f.sig = shift(f.sig,nn,dim,cyclic);
  end
  