
function p=sigcat(p,int_index)

% function p=sigcat(p,int_index)
%
% concatenate signal portion of p
%
%   set int_index=1 to make the x-axis
%   be labeled with signal indices (defaults to 0)

% arg process

   if nargin<2, int_index=0; end

% matrix case

   for ii=1:length(p(:))
     p(ii)=scalar(p(ii),int_index);
   end
   

% scalar case

function p=scalar(p,int_index)

    if size(p.sig,2)==1, return, end

    if int_index
      delta = 1./size(p.sig,1);
      p.d0  = 1;
      p.xlabel ='Index';
    else
      delta = p.d(1);
    end
    
    p.sig = p.sig(:);
    p.d   = sample_structure(delta,p.sig);

%    p.d0  = 1;
   


