
function r=split(p)

% function r=split(p)
%
% Split a 1x1 sampled signal object into a
% multi-dimensional sampled signal object of the
% same dimensions as the .sig element of input
%
% See Also join.m

   if length(p)>1
     error('Argument must be 1x1')
   end
   
   
   for ii=1:size(p.sig,2)
     r(ii)=p;
     r(ii).sig = p.sig(:,ii);
   end

   r=r(:); % make it a column
   
% name
     
   nsig = size(p.sig,2);
   if strcmp(p.nametrack,'on') & nsig~=1
     for ii=1:nsig
       r(ii).name= sprintf('%s_{%d}',p.name,ii);
     end
   end

