
function p=sum(p,dim)

% function p=sum(p,dim)
%
% Performs sum on the sig element of p
% (dim=2 by default)

% arg process

   if nargin<2, dim=2; end
   
% matrix case

   for ii=1:length(p(:))
     r(ii)=scalar(p(ii),dim);
   end
   p=r;
   

% scalar case

function p=scalar(p,dim)

   p.sig  = sum(p.sig,dim);
   
   if length(p.sig)==1
     p=p.sig;
     return
   end
   
   if strcmp(p.nametrack,'on')
     p.name = sprintf('\\Sigma %s',p.name);
   end   
 
   if dim==1
     if ~isempty(p.dy)
       p.d  = p.dy;
       p.d0 = p.dy0;
       p.xlabel = p.ylabel;
     else
       p.d  = [1 size(p.sig,2)/2];
       p.d0 = 1;
       p.xlabel = 'Index';
     end
     
   end
   
